﻿using System;
using System.ComponentModel;
using System.ComponentModel.Design;
using System.Collections;
using System.Drawing;
using System.Linq;
using System.Workflow.ComponentModel.Compiler;
using System.Workflow.ComponentModel.Serialization;
using System.Workflow.ComponentModel;
using System.Workflow.ComponentModel.Design;
using System.Workflow.Runtime;
using System.Workflow.Activities;
using System.Workflow.Activities.Rules;

namespace Lessons.Workflows
{

    /* CallExternalMethodActivity 
     
        This example uses two CallExternalMethodActivity objects.
        The first one calls the external method passing as an argument a value defined at design-time
        by using the Property Grid.
     
        The second CallExternalMethodActivity uses the MethodInvoking event and
        assigns the parameter passed to the external method by using the 
        ParameterBindings property of the CallExternalMethodActivity
    
     */
    public sealed partial class Workflow1: SequentialWorkflowActivity
	{
		public Workflow1()
		{
			InitializeComponent();
		}

        public string MessageText { get; set; }


        /* MethodInvoking event handlers are called just before the invocation of the 
           interface method defined in the InterfaceType and MethodName properties of
           the CallExternalMethodActivity */
        private void callExternalMethodActivity1_MethodInvoking(object sender, EventArgs e)
        {
            Console.WriteLine("What's your name?");
            MessageText = string.Format("Hi there {0}", Console.ReadLine());
        }


        /* the  CallExternalMethodActivity.ParameterBindings collection property gives access to the parameters  
           of the method being called */
        private void callExternalMethodActivity2_MethodInvoking(object sender, EventArgs e)
        {
            CallExternalMethodActivity a = sender as CallExternalMethodActivity;
            WorkflowParameterBinding wpb = a.ParameterBindings.GetItem("Text");
            wpb.Value = "This value is assigned programmaticaly using the MethodInvoking event";
        }


	}

}
